/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	FixLine.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"

HRESULT FixLine(ISet *objSet)
{
	//	Applies the FixedLine constraint on the set of given lines

	START_METHOD("FixLine")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Get any member of the objectSet1
	IDispatch *pDispObject = NULL;
	status = objSet->GetAnyMember(&pDispObject);
	CHECK_RETURN_STATUS(status)

	IObject *object = CAST(IObject, pDispObject);

	// Get the parent workplane of the object
	IObject *parentWorkplane = NULL;
	status = object->GetParent(GetBSTR("Workplane"), &parentWorkplane);
	CHECK_RETURN_STATUS(status)

	long index1 = 0;
	
	long noOfObjects1 = 0;
	//Get the number of objects in objectSet1 ( to iterate through the set )
	status = objSet->GetCount(&noOfObjects1);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(objSet,&pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *line1 = NULL;

	pObjectIt->start(&line1);
	while (line1) {

		IFixedLine *pFixedLine = NULL;
		status = (GetCLASS(FixedLine))->CreateFixedLine(CAST(ILine, line1), &pFixedLine);
		CHECK_RETURN_STATUS(status)

		IConstraint *pConstraint1 = NULL;

		status = CAST(IWorkplane, parentWorkplane)->GetConstraint(CAST(IGeomConstraint, pFixedLine), &pConstraint1);
		CHECK_RETURN_STATUS(status)

			if (pConstraint1) {
				pDispObject->Release();

			}
			else {

				IConstraint *pConstraint2 = NULL;
				status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint, pFixedLine), &pConstraint2);
				CHECK_RETURN_STATUS(status)
			}

	line1 = NULL;
	pObjectIt->Next(&line1);
	}

	END_METHOD("FixLine")
}
